/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include "udm_config.h"
#include <stdio.h>
#include "udm_uniconv.h"


void UdmConvInit(UDM_CONV *cnv,UDM_CHARSET *from,UDM_CHARSET *to, int fl)
{
  cnv->from=from;
  cnv->to=to;
  cnv->flags=fl;
  cnv->ibytes=0;
  cnv->obytes=0;
  cnv->icodes = cnv->ocodes = 1; /* default for old functions */
  cnv->istate = cnv->ostate = 0; /* default state */
}

int UdmConv(UDM_CONV *c, char *d, size_t dlen,const char *s, size_t slen)
{
  int		i, res, wc[16]; /* does 16 is enough? */
  int           zero = 0;
  char		*d_o=d;
  const char	*s_e=s+slen;
  char		*d_e=d+dlen;
  const char	*s_o=s;
  
  c->istate = 0; /* set default state */
  c->ostate = 0; /* set default state */
  while(s<s_e && d<d_e){
    
    res=c->from->mb_wc(c, c->from, wc,
                       (const unsigned char*)s,
                       (const unsigned char*)s_e);
    if (res>0)
    {
      s+=res;
    }
    else if (res==UDM_CHARSET_ILSEQ)
    {
      if (1)
      {
        s++;
        wc[0] = '?';
      }
      else
        break;
    }
    else
      break;

    for(i = 0; i < c->ocodes; i += c->icodes) {
outp:
      res = c->to->wc_mb(c, c->to, &wc[i], (unsigned char*)d, (unsigned char*)d_e);
      if (res > 0) {
	d += res;
      }
      else if (res == UDM_CHARSET_ILUNI && wc[i] != '?') {
	if (c->flags && UDM_RECODE_HTML) {
	  if (d_e-d > 8) {
	    res = sprintf(d, "&#%d;", wc[i]);
	    d += res;
	  }
	  else
	    break;
	}
	else if (1) {
	  wc[i] = '?';
	  goto outp;
	} else {
	  break;
	}
      } else
	goto outaway;
    }
  };

outaway:  
  if(d<=d_e)
    res = c->to->wc_mb(c, c->to, &zero, (unsigned char*)d, (unsigned char*)d_e);
  c->ibytes=s-s_o;
  return (c->obytes = d - d_o );
}
